var g_UseRadius = true;

function OnPoint( pointpicker )
{
    var radius = moi.vectorMath.distance( pointpicker.basept, pointpicker.pt );

    var value = radius;
	if ( !g_UseRadius )
	    value *= 2.0;
		
	distanceinput.value = value;

	circumference.value = radius * 2.0 * Math.PI;
}

function SetDiameterActive()
{
	g_UseRadius = false;
	_RadiusPrompt.style.display = 'none';
	_DiameterPrompt.style.display = 'inline';
	_RadiusButton.style.display = 'none';
	_DiameterButton.style.display = 'inline';
}

function SetRadiusActive()
{
	g_UseRadius = true;
	_RadiusPrompt.style.display = 'inline';
	_DiameterPrompt.style.display = 'none';
	_RadiusButton.style.display = 'inline';
	_DiameterButton.style.display = 'none';
}

function ToggleRadiusDiameter()
{
	if ( g_UseRadius )
		SetDiameterActive();
	else
		SetRadiusActive();
}

function Initialize()
{
	// First see if there is a UseDiameterDefault=y set in the moi.ini file, if there
	// is then use that as an initial default.
	
	var IniKey = 'UseDiameterDefault';
	
	try
	{
		var UseDiameter = moi.command.getOption( IniKey, true );
		g_UseRadius = !UseDiameter;
	}
	catch(e)
	{
		// There was no UseDiameterDefault= entry in commands option section,
		// write out a default of n.
		moi.command.setOption( IniKey, false, true );
	}
	
	// Next see if there is a command-specific saved value, if it is let it override the
	// .ini file default.
	try	{
		g_UseRadius = moi.command.getOption( document.URL + '_UseRadius' );
	} catch(e) {}
	
	if ( g_UseRadius )
		SetRadiusActive();
	else
		SetDiameterActive();
}

function Shutdown()
{
	try {
		moi.command.setOption( document.URL + '_UseRadius', g_UseRadius );
	} catch(e) {}
}
